﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// View model for a prescription and dispense view for particular patient.
    /// </summary>
    public class PrescriptionDispenseViewModel : PcehrViewModelBase, IValidatableObject
    {
        [Required(ErrorMessage = "'From' date is required.")]
        [Display(Name = "From"), DisplayFormat(DataFormatString = "dd/MM/yyyy")]
        public DateTime? FromDate { get; set; }

        [Required(ErrorMessage = "'To' date is required.")]
        [Display(Name = "To"), DisplayFormat(DataFormatString = "dd/MM/yyyy")]
        public DateTime? ToDate { get; set; }

        [Display(Name = "Group By")]
        public string GroupBy { get; set; }

        public IEnumerable<SelectListItem> GroupByOptions { get; internal set; }

        /// <summary>
        /// Determines whether the specified object is valid.
        /// </summary>
        /// <returns>
        /// A collection that holds failed-validation information.
        /// </returns>
        /// <param name="validationContext">The validation context.</param>
        public IEnumerable<ValidationResult> Validate(ValidationContext validationContext)
        {
            if (ToDate.HasValue && ToDate.Value.Date > DateTime.Today)
            {
                yield return new ValidationResult("'To' date cannot be in the future.");
            }
            if (ToDate.HasValue && FromDate.HasValue && FromDate.Value.Date > ToDate.Value.Date)
            {
                yield return new ValidationResult("'To' date must be after the 'From' date.");
            }
            if (!(new[] { "prescription", "genericName", "pbsItemCode", "brandName" }).Contains(GroupBy))
            {
                yield return new ValidationResult("Invalid 'Group By' value provided.");
            }
        }

        /// <summary>
        /// Returns a string that represents the current object.
        /// </summary>
        /// <returns>
        /// A string that represents the current object.
        /// </returns>
        /// <remarks>
        /// Used to determine VaryByParam caching.
        /// GetHashCode() may collide (though unlikely) but is more maintainable than updating as ViewModel changes.
        /// </remarks>
        public override string ToString()
        {
            return this.GetHashCode().ToString();
        }
    }
}